# Introduction
This repository contains the scripts to integrate DALI to Chameleon.

# Requirements
- pip `apt install python-pip`
- Flask `pip install Flask`
- pyserial `pip install pyserial`

# Files
- move daligateway.py file to `/root/` folder
- move daligateway.service file to `/lib/systemd/system/` folder

# Start service
- `sudo systemctl daemon-reload`
- `sudo systemctl enable dali-gateway.service`
- `sudo systemctl start dali-gateway.service`
- *optional* `sudo systemctl status dali-gateway.service`

# Creating Virtual Shutter
- Go to config site.
- `Integrations` menu -> `Create new virtual device` option
- Select `Virtual Dimmer` and `Without authentication` other options leave blank
- `Devices` menu -> `Details` on the new Virtual dimmer
- Set HTTP on url to `http://127.0.0.1:3000/?address=0&value={value}`
- Set HTTP off url to `http://127.0.0.1:3000/?address=0&value={value}`

# Creating Virtual Switch
- Go to config site.
- `Integrations` menu -> `Create new virtual device` option
- Select `Virtual Switch` and `Without authentication` other options leave blank
- `Devices` menu -> `Details` on the new Virtual switch
- Set HTTP on url to `http://127.0.0.1:3000/?address=0&value=100`
- Set HTTP off url to `http://127.0.0.1:3000/?address=0&value=0`