#!/user/bin/env python3
import flask
import json
import ipaddress
import math
import os
import serial
from flask import request,jsonify

CONTROL = 0b10000011 #FIX
D_HIGH = 0b00000000 #NOTUSED
#D_MID = 0b00000000 ADDRESS
#D_LOW = 0b11111110 DIM 0-254

app = flask.Flask(__name__)
app.config["DEBUG"] = True
demiliter = "\\"

ser = serial.Serial(
    port='/dev/ttyUSB0',
    baudrate = 38400,
    parity=serial.PARITY_NONE,
    stopbits=serial.STOPBITS_ONE,
    bytesize=serial.EIGHTBITS,
    timeout=1
)

@app.route('/', methods=['GET'])
def home():

    address = request.args.get('address', type = int)
    value = request.args.get('value',  type = int)
    rounded = round(254 * value / (100))
    checksum = CONTROL ^ D_HIGH ^ address ^ int(rounded)

    xs = bytearray()
    xs.append(CONTROL)
    xs.append(D_HIGH)
    xs.append(address)
    xs.append(int(rounded))
    xs.append(int(checksum))

    ser.write(xs)

    stringSent = demiliter + str(hex(CONTROL))[1:] +demiliter +str(hex(D_HIGH))[1:] +demiliter +str(hex(address))[1:] +demiliter +str(hex(int(rounded)))[1:] +demiliter + hex(checksum)[1:]
    print(stringSent)

    resp = jsonify(success=True)
    resp.status_code = 200
    return resp

app.run(host='127.0.0.1',port=3000)
